/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.mixin.common;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.betterx.bclib.blocks.BlockProperties;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.registry.EndBlocks;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class}, priority=200)
public abstract class PlayerMixin
extends LivingEntity {
    private static Direction[] horizontal;

    protected PlayerMixin(EntityType<? extends LivingEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"findRespawnPositionAndUseSpawnBlock"}, at={@At(value="HEAD")}, cancellable=true)
    private static void be_findRespawnPositionAndUseSpawnBlock(ServerLevel world, BlockPos pos, float f, boolean bl, boolean bl2, CallbackInfoReturnable<Optional<Vec3>> info) {
        BlockState blockState = world.m_8055_(pos);
        if (blockState.m_60713_(EndBlocks.RESPAWN_OBELISK)) {
            info.setReturnValue(PlayerMixin.be_obeliskRespawnPosition(world, pos, blockState));
            info.cancel();
        }
    }

    private static Optional<Vec3> be_obeliskRespawnPosition(ServerLevel world, BlockPos pos, BlockState state) {
        if (state.m_61143_((Property)BlockProperties.TRIPLE_SHAPE) == BlockProperties.TripleShape.TOP) {
            pos = pos.m_6625_(2);
        } else if (state.m_61143_((Property)BlockProperties.TRIPLE_SHAPE) == BlockProperties.TripleShape.MIDDLE) {
            pos = pos.m_7495_();
        }
        if (horizontal == null) {
            horizontal = BlocksHelper.makeHorizontal();
        }
        MHelper.shuffle((Object[])horizontal, (RandomSource)world.m_213780_());
        for (Direction dir : horizontal) {
            BlockPos p = pos.m_121945_(dir);
            BlockState state2 = world.m_8055_(p);
            if (state2.m_280555_() || !state2.m_60812_((BlockGetter)world, pos).m_83281_()) continue;
            return Optional.of(Vec3.m_82528_((Vec3i)p).m_82520_(0.5, 0.0, 0.5));
        }
        return Optional.empty();
    }
}

